<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;
if (empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
	header("Location: index.php");
	exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="author" content="P2PLAY Apps">
	<title>9x 4K by P2PLAY</title>

	<!-- Favicons -->
	<link rel="apple-touch-icon" sizes="180x180" href="./img/favicons/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="./img/favicons/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="./img/favicons/favicon-16x16.png">
	<link rel="manifest" href="./img/favicons/site.webmanifest">
	<link rel="shortcut icon" href="./img/favicons/favicon.ico">
	<meta name="theme-color" content="#0a0f2b">

	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" crossorigin="anonymous">
	<link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
	<link href="css/simple-sidebar.css" rel="stylesheet">

	<style>
		:root {
			--primary-blue: #003366;
			--dark-blue: #001a33;
			--light-blue: #00AEEF;
			--gold: #FFD166;
			--green: #28a745;
			--dark-green: #1e7e34;
			--red: #dc3545;
			--dark-red: #a71d2a;
			--black: #0A0A0A;
			--text-light: #F8F9FA;
		}

		body {
			background: linear-gradient(135deg, var(--black) 0%, var(--primary-blue) 100%);
			color: var(--text-light);
			min-height: 100vh;
			background-attachment: fixed;
			font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
		}

		#js-particles {
			position: fixed;
			inset: 0;
			width: 100%;
			height: 100%;
			z-index: 0;
			pointer-events: none;
		}

		#sidebar-wrapper {
			background: linear-gradient(to bottom, var(--black), var(--dark-blue));
			box-shadow: 3px 0 15px rgba(0, 0, 0, 0.6);
			border-right: none;
		}

		.sidebar-heading {
			background: transparent;
			color: var(--gold);
			padding: 20px 15px;
			font-size: 1.3rem;
			font-weight: bold;
			text-align: center;
			border-bottom: 2px solid rgba(255,255,255,0.05);
		}

		.list-group-item {
			background-color: transparent;
			border: none;
			color: #DDD;
			padding: 15px 20px;
			margin: 5px 0;
			transition: all 0.3s ease;
		}
		.list-group-item:hover {
			background: rgba(0, 174, 239, 0.12);
			color: var(--gold);
			padding-left: 25px;
			border-left: 3px solid var(--light-blue);
		}
		.list-group-item i {
			color: var(--light-blue);
			width: 25px;
		}

		.navbar {
			background: linear-gradient(to right, var(--dark-blue), var(--primary-blue));
			box-shadow: 0 2px 12px rgba(0,0,0,0.5);
		}

		#menu-toggle {
			background: var(--light-blue);
			border: none;
			border-radius: 50%;
			width: 40px;
			height: 40px;
			display: flex;
			align-items: center;
			justify-content: center;
			box-shadow: 0 2px 5px rgba(0,0,0,0.3);
			color: #fff;
		}
		#menu-toggle:hover {
			background: #0095cc;
			transform: scale(1.08);
		}

		.btn-danger {
			background: var(--gold);
			border: none;
			border-radius: 20px;
			color: #000;
			font-weight: bold;
		}
		.btn-danger:hover {
			background: #e6b800;
			transform: translateY(-2px) scale(1.05);
		}

		.container-fluid {
			background: rgba(10,10,10,0.65);
			border-radius: 10px;
			padding: 20px;
			margin-top: 20px;
			box-shadow: 0 8px 20px rgba(0,0,0,0.45);
			border: 1px solid rgba(0, 174, 239, 0.25);
		}

		/* Alerts */
		.alert-success {
			background: linear-gradient(90deg, var(--green), var(--dark-green));
			color: #fff;
			border: none;
		}
		.alert-danger {
			background: linear-gradient(90deg, var(--red), var(--dark-red));
			color: #fff;
			border: none;
		}

		@media (max-width: 768px) {
			#wrapper { flex-direction: column; }
			#sidebar-wrapper {
				width: 100%;
				position: fixed;
				top: 0;
				left: -100%;
				height: 100vh;
				transition: all 0.5s ease;
				z-index: 1050;
			}
			#wrapper.toggled #sidebar-wrapper { left: 0; }
			#page-content-wrapper { padding-top: 60px; margin-left: 0; }
			.navbar { position: fixed; width: 100%; top: 0; z-index: 1040; }
		}
	</style>
</head>
<body>
	<div id="js-particles"></div>

	<div class="d-flex" id="wrapper">
		<div id="sidebar-wrapper">
			<div class="sidebar-heading">9xtream 4K</div>
			<span>
				<a class="list-grup-item" href="https://t.me/p2playapps" target="_blank" style="color: #EEE; padding: 10px; display: block; text-align: center;">
					&copy; <?=date("Y")?> * P2PLAY Apps *
				</a>
			</span>
			<div class="list-group list-group-flush">
				<a class="list-group-item list-group-item-action" href="dns.php">
					<i class="fa fa-server"></i>&nbsp;&nbsp; SERVIDORES
				</a>
				<a class="list-group-item list-group-item-action" href="actusers.php">
					<i class="fa fa-users"></i>&nbsp;&nbsp; CONECTADOS
				</a>
				<a class="list-group-item list-group-item-action" href="chatbot.php">
					<i class="fa-solid fa-robot"></i>&nbsp;&nbsp; TESTE AUTOMATICO
				</a>
				<a class="list-group-item list-group-item-action" href="logo.php">
					<i class="fa fa-image"></i>&nbsp;&nbsp; ALTERAR LOGOTIPO
				</a>
				<a class="list-group-item list-group-item-action" href="bg.php">
					<i class="fa fa-paint-brush"></i>&nbsp;&nbsp; ALTERAR FUNDO
				</a>
				<a class="list-group-item list-group-item-action" href="user.php">
					<i class="fa fa-user"></i>&nbsp;&nbsp; PERFIL
				</a>
			</div>
		</div>
		<div id="page-content-wrapper">
			<nav class="navbar navbar-expand-lg navbar-dark">
				<button class="btn btn-primary" id="menu-toggle">
					<i class="fas fa-bars"></i>
				</button>
				&nbsp;&nbsp;
				<div class="center" id="pageMessages"></div>
				<a href="logout.php" class="btn btn-danger ml-auto mr-1">Logout</a>
			</nav>

			<div class="container-fluid"><br>


