<?php
$db_file = __DIR__ . "/.db.db";

$device_id = $_GET['device_id'] ?? null;
if (!$device_id) {
    die("Device ID não fornecido.");
}

try {
    $db = new PDO("sqlite:$db_file");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Remove ':' do mac_address no SELECT para comparar
    $stmt = $db->prepare("
        SELECT link 
        FROM playlist 
        WHERE REPLACE(mac_address, ':', '') = :mac_address 
        LIMIT 1
    ");
    $stmt->execute([':mac_address' => $device_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || empty($row['link'])) {
        die("Link não encontrado para este dispositivo.");
    }

    header("Location: " . $row['link']);
    exit;

} catch (Exception $e) {
    die("Erro ao acessar banco de dados: " . $e->getMessage());
}
