<?php
/**
 * Script de Reset de Credenciais de Administrador para Banco de Dados SQLite (.db.db)
 * 
 * Este script conecta-se ao banco de dados SQLite e atualiza o primeiro registro 
 * na tabela 'users' (assumindo que seja o admin) com novas credenciais.
 * 
 * Para segurança, é necessário fornecer uma senha mestra via formulário.
 * 
 * ATENÇÃO: Este script assume que as senhas são armazenadas em texto simples.
 * Se o seu sistema utiliza hash (como MD5 ou bcrypt), você precisará modificar 
 * a variável $nova_senha para incluir o hash da senha desejada.
 */

// -----------------------------------------------------------------------------
// CONFIGURAÇÃO DE SEGURANÇA
// -----------------------------------------------------------------------------
$senha_mestra_necessaria = '#T130998z'; // **ALTERE ESTA SENHA**
$db_file = '.db.db';
$novo_usuario = 'admin';
$nova_senha = 'admin'; // Senha solicitada pelo usuário
// -----------------------------------------------------------------------------

$base_url = 'https://9x4k.thayz.xyz/playdigital';
$current_url = 'https://9x4k.thayz.xyz/playdigital/api/reset_senha.php';
$reset_confirmado = isset($_POST['confirmar_reset']) && $_POST['confirmar_reset'] == 'true';
$senha_fornecida = isset($_POST['senha_mestra']) ? $_POST['senha_mestra'] : '';

// Função para exibir o formulário de senha
function exibir_formulario($current_url) {
    echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Reset de Senha de Administrador</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #121212; color: #e0e0e0; text-align: center; padding-top: 50px; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .container { background-color: #1e1e1e; padding: 30px; border-radius: 8px; box-shadow: 0 0 20px rgba(0, 0, 0, 0.5); width: 90%; max-width: 400px; }
        input[type="password"], button { padding: 10px; margin: 10px 0; width: 100%; box-sizing: border-box; border: 1px solid #333; background-color: #2c2c2c; color: #e0e0e0; border-radius: 4px; }
        button { background-color: #007bff; color: white; border: none; cursor: pointer; font-weight: bold; }
        button:hover { background-color: #0056b3; }
        .aviso { color: #ffeb3b; margin-top: 15px; }
        label { display: block; text-align: left; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Reset de Senha de Administrador</h2>
        <p><strong>URL a ser resetada:</strong> {$current_url}</p>
        <form method="POST" action="{$current_url}">
            <label for="senha_mestra">INSERIR SENHA MESTRA:</label>
            <input type="password" id="senha_mestra" name="senha_mestra" required><br>
            <button type="submit">Confirmar Senha</button>
        </form>
        <p class="aviso">Atenção: Este script irá resetar o usuário e senha de administrador para '{$GLOBALS['novo_usuario']}' e '{$GLOBALS['nova_senha']}'.</p>
    </div>
</body>
</html>
HTML;
}

// Função para exibir a confirmação de reset
function exibir_confirmacao($current_url, $senha_fornecida) {
    echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Confirmação de Reset</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #121212; color: #e0e0e0; text-align: center; padding-top: 50px; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .container { background-color: #1e1e1e; padding: 30px; border-radius: 8px; box-shadow: 0 0 20px rgba(0, 0, 0, 0.5); width: 90%; max-width: 400px; }
        button { padding: 10px 20px; margin: 10px 0; background-color: #dc3545; color: white; border: none; cursor: pointer; font-weight: bold; width: 100%; border-radius: 4px; }
        button:hover { background-color: #c82333; }
        .aviso { color: #ffeb3b; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Confirmação de Reset</h2>
        <p>Tem certeza que deseja resetar as credenciais de administrador?</p>
        <p><strong>URL de Acesso:</strong> {$current_url}</p>
        <p class="aviso">Esta ação irá resetar o usuário e senha de administrador para '{$GLOBALS['novo_usuario']}' e '{$GLOBALS['nova_senha']}'.</p>
        <form method="POST" action="{$current_url}">
            <input type="hidden" name="senha_mestra" value="{$senha_fornecida}">
            <input type="hidden" name="confirmar_reset" value="true">
            <button type="submit">SIM, CONFIRMAR RESET</button>
        </form>
    </div>
</body>
</html>
HTML;
}

// Função para exibir o resultado do reset
function exibir_resultado($base_url, $novo_usuario, $nova_senha, $mensagem) {
    $login_url = $base_url;
    // Concatena as informações para facilitar a cópia
    $texto_para_copiar = "URL de Acesso: {$login_url}\nNovo Usuário: {$novo_usuario}\nNova Senha: {$nova_senha}";

    echo <<<HTML
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Reset Concluído</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #121212; color: #e0e0e0; text-align: center; padding-top: 50px; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .container { background-color: #1e1e1e; padding: 30px; border-radius: 8px; box-shadow: 0 0 20px rgba(0, 0, 0, 0.5); width: 90%; max-width: 450px; }
        .success { color: #4CAF50; font-weight: bold; }
        .error { color: #f44336; font-weight: bold; }
        .credentials { background-color: #2c2c2c; padding: 15px; border-radius: 4px; margin: 20px 0; text-align: left; border: 1px solid #444; }
        .credentials p { margin: 5px 0; }
        button { padding: 12px 20px; margin: 20px 0 10px 0; background-color: #28a745; color: white; border: none; cursor: pointer; font-weight: bold; width: 100%; border-radius: 4px; }
        button:hover { background-color: #218838; }
        .aviso { color: #ffeb3b; margin-top: 15px; }
        strong { color: #ffffff; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Reset Concluído</h2>
        <p class="success">{$mensagem}</p>
        
        <div class="credentials">
            <p><strong>URL de Acesso:</strong> <span id="loginUrl">{$login_url}</span></p>
            <p><strong>Novo Usuário:</strong> <span id="newUsername">{$novo_usuario}</span></p>
            <p><strong>Nova Senha:</strong> <span id="newPassword">{$nova_senha}</span></p>
        </div>
        
        <button onclick="copyToClipboard()">Copiar Todas as Informações</button>

        <p class="aviso">RECOMENDAÇÃO: Exclua este arquivo 'reset_admin.php' imediatamente após o uso por questões de segurança.</p>
    </div>

    <script>
        function copyToClipboard() {
            const textToCopy = decodeURIComponent("{$texto_para_copiar}");
            navigator.clipboard.writeText(textToCopy).then(function() {
                alert('Copiado para a área de transferência:\n' + textToCopy);
            }, function(err) {
                console.error('Erro ao copiar: ', err);
                alert('Erro ao copiar. Por favor, copie manualmente:\n' + textToCopy);
            });
        }
    </script>
</body>
</html>
HTML;
}

// -----------------------------------------------------------------------------
// LÓGICA PRINCIPAL
// -----------------------------------------------------------------------------

// 1. Não há senha fornecida ou a senha está incorreta
if (empty($senha_fornecida) || $senha_fornecida !== $senha_mestra_necessaria) {
    if (!empty($senha_fornecida)) {
        // Senha incorreta, exibe erro e formulário novamente
        echo "<script>alert('Senha Mestra Incorreta!');</script>";
    }
    exibir_formulario($current_url);
    exit;
}

// 2. Senha correta, mas ainda não confirmou o reset
if ($senha_fornecida === $senha_mestra_necessaria && !$reset_confirmado) {
    exibir_confirmacao($current_url, $senha_fornecida);
    exit;
}

// 3. Senha correta e reset confirmado
if ($senha_fornecida === $senha_mestra_necessaria && $reset_confirmado) {
    try {
        // Verificar se o arquivo do banco de dados existe
        if (!file_exists($db_file)) {
            exibir_resultado($base_url, $novo_usuario, $nova_senha, "ERRO: O arquivo do banco de dados '{$db_file}' não foi encontrado na mesma pasta.");
            exit;
        }

        // Conectar ao banco de dados SQLite
        $db = new PDO("sqlite:" . $db_file);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Preparar e executar o comando SQL de atualização
        $sql = "UPDATE users SET username = :username, password = :password WHERE id = 1";
        $stmt = $db->prepare($sql);

        // Bind dos parâmetros e execução
        $stmt->bindParam(':username', $novo_usuario);
        $stmt->bindParam(':password', $nova_senha);
        $stmt->execute();

        // Verificar o número de linhas afetadas
        $linhas_afetadas = $stmt->rowCount();

        if ($linhas_afetadas > 0) {
            exibir_resultado($base_url, $novo_usuario, $nova_senha, "SUCESSO: As credenciais do administrador foram resetadas!");
        } else {
            exibir_resultado($base_url, $novo_usuario, $nova_senha, "AVISO: Nenhuma linha foi atualizada. Verifique se a tabela 'users' e o ID=1 existem.");
        }

        // Fechar a conexão
        $db = null;

    } catch (PDOException $e) {
        exibir_resultado($base_url, $novo_usuario, $nova_senha, "ERRO de Banco de Dados: " . $e->getMessage());
    } catch (Exception $e) {
        exibir_resultado($base_url, $novo_usuario, $nova_senha, "ERRO: " . $e->getMessage());
    }
}

?>