<?php
session_start();

// Verificação de login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include('includes/header.php');

// Caminho do arquivo logo
$uploadDir = __DIR__ . '/img/';
$uploadFile = $uploadDir . 'logo.png';

// Upload da imagem
if (isset($_POST['submit'])) {
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmpName = $_FILES['logo']['tmp_name'];

        // Verifica se é uma imagem válida
        $check = getimagesize($tmpName);
        if ($check !== false) {
            if (move_uploaded_file($tmpName, $uploadFile)) {
                $msg = "<div class='alert alert-success text-center'>✅ Logo atualizada com sucesso!</div>";
            } else {
                $msg = "<div class='alert alert-danger text-center'>❌ Erro ao salvar a logo.</div>";
            }
        } else {
            $msg = "<div class='alert alert-warning text-center'>⚠️ O arquivo enviado não é uma imagem válida.</div>";
        }
    } else {
        $msg = "<div class='alert alert-danger text-center'>📂 Nenhum arquivo selecionado ou erro no upload.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de Logo</title>
    <style>
        :root {
            --primary-blue: #003366;
            --dark-blue: #001a33;
            --light-blue: #00AEEF;
            --gold: #FFD166;
            --green: #28a745;
            --dark-green: #1e7e34;
            --red: #dc3545;
            --dark-red: #a71d2a;
            --black: #0A0A0A;
            --text-light: #F8F9FA;
        }

        body {
            background: linear-gradient(135deg, var(--black), var(--dark-blue));
            color: var(--text-light);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }

        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .main-content {
            flex: 1;
            padding: 40px 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
        }

        .card-custom {
            background: rgba(0, 0, 0, 0.75);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 174, 239, 0.25);
            border: 1px solid rgba(0, 174, 239, 0.3);
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
        }

        .card-header-custom {
            background: linear-gradient(90deg, var(--dark-blue), var(--primary-blue));
            padding: 20px;
            border-bottom: 2px solid var(--light-blue);
            text-align: center;
            color: var(--gold);
            font-weight: bold;
        }

        .card-body-custom {
            padding: 30px;
            text-align: center;
        }

        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(0, 174, 239, 0.3);
            color: #fff;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            margin-bottom: 20px;
        }

        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--light-blue);
            box-shadow: 0 0 0 0.2rem rgba(0, 174, 239, 0.35);
            color: #fff;
        }

        .form-label {
            font-weight: 600;
            color: var(--gold);
            margin-bottom: 8px;
            display: block;
            font-size: 1.1em;
        }

        .btn-custom {
            background: linear-gradient(45deg, var(--light-blue), var(--primary-blue));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: #fff; /* texto branco */
            transition: all 0.3s;
            margin-top: 15px;
            cursor: pointer;
        }

        .btn-custom:hover {
            background: linear-gradient(45deg, var(--primary-blue), var(--dark-blue));
            transform: translateY(-2px);
        }

        .current-logo {
            margin-bottom: 30px;
        }

        .current-logo img {
            max-height: 200px;
            max-width: 100%;
            background: #fff;
            padding: 15px;
            border-radius: 10px;
            border: 1px solid rgba(0, 174, 239, 0.3);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.35);
        }

        /* Alertas */
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid transparent;
        }
        .alert-success {
            background: rgba(40, 167, 69, 0.15);
            border-color: rgba(40, 167, 69, 0.3);
            color: #d4edda;
        }
        .alert-danger {
            background: rgba(220, 53, 69, 0.15);
            border-color: rgba(220, 53, 69, 0.3);
            color: #f8d7da;
        }
        .alert-warning {
            background: rgba(255, 193, 7, 0.15);
            border-color: rgba(255, 193, 7, 0.3);
            color: #fff3cd;
        }

        @media (max-width: 768px) {
            .card-body-custom { padding: 20px; }
            .btn-custom { width: 100%; }
            .current-logo img { max-height: 180px; }
        }
        @media (max-width: 576px) {
            .card-body-custom { padding: 15px; }
            .current-logo img { max-height: 150px; }
        }
    </style>
</head>
<body>
<div class="page-container">
    <div class="main-content">
        <div class="card-custom">
            <div class="card-header-custom">
                <h2><span class="emoji">🖼️</span> Gerenciar Logo</h2>
                <p><span class="emoji">📌</span> Envie uma nova imagem para substituir a logo atual</p>
            </div>
            
            <div class="card-body-custom">
                <?php if (isset($msg)) echo $msg; ?>
                
                <div class="current-logo">
                    <h4><span class="emoji">🔎</span> Logo Atual</h4>
                    <img src="img/logo.png?<?=time()?>" alt="Logo atual">
                </div>
                
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="logo" class="form-label">
                            <span class="emoji">📤</span> Selecione uma nova imagem:
                        </label>
                        <input type="file" class="form-control" name="logo" id="logo" accept="image/*" required>
                    </div>
                    <button class="btn-custom" name="submit" type="submit">
                        <span class="emoji">🚀</span> Enviar / Substituir Logo
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
</body>
</html>
