<?php
session_start();
include('includes/functions.php');

$login_error = "";

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if (!empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

$data = ['id' => '1', 'username' => 'admin', 'password' => 'admin'];
$db->insertIfEmpty('users', $data);

if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $userData = $db->select('users', '*', 'username = :username', '', [':username' => $username]);
    if ($userData) {
        $storedPassword  = $userData[0]['password'];
        $enteredPassword = $_POST["password"];
        if ($enteredPassword == $storedPassword) {
            session_regenerate_id(true);
            $_SESSION['loggedin'] = true;
            $_SESSION['name'] = $_POST['username'];
            if ($_POST['username'] === 'admin') {
                header('Location: user.php'); exit;
            } else {
                header('Location: dns.php'); exit;
            }
        } else {
            $login_error = "Usuário ou senha inválidos!";
        }
    } else {
        $login_error = "Usuário ou senha inválidos!";
    }
    $db->close();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>9x 4K by P2PLAY</title>
  <meta name="theme-color" content="#0a0f2b">

  <!-- Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="./img/favicons/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="./img/favicons/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="./img/favicons/favicon-16x16.png">
  <link rel="manifest" href="./img/favicons/site.webmanifest">
  <link rel="shortcut icon" href="./img/favicons/favicon.ico">

  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">

  <style>
    body {
      margin: 0;
      height: 100vh;
      overflow: hidden;
      background: #0a0f2b;
      color: #fff;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    #particles-js {
      position: fixed;
      inset: 0;
      z-index: 0;
    }
    .particles-js-canvas-el {
      pointer-events: none !important;
    }

    .login-card {
      position: relative;
      z-index: 1;
      background: rgba(10,15,43,0.7);
      border: 1px solid rgba(255,255,255,0.08);
      border-radius: 16px;
      padding: 30px;
      width: 100%;
      max-width: 400px;
      box-shadow: 0 20px 60px rgba(0,0,0,.45);
      transform: perspective(800px) rotateX(var(--tiltX,0deg)) rotateY(var(--tiltY,0deg));
      transition: transform .12s ease-out, box-shadow .2s ease;
    }
    .login-card:hover {
      box-shadow: 0 24px 70px rgba(0,0,0,.55), 0 0 40px rgba(0,170,255,.08);
    }

    .logo {
      width: 200px;
      margin: 0 auto 20px;
      display: block;
    }

    .btn-login {
      font-size: 1.1rem;
      font-weight: 700;
      padding: 12px;
      border-radius: 12px;
      border: none;
      cursor: pointer;
      background: linear-gradient(45deg, #FFD166, #00AEEF);
      color: #0a0f2b;
      box-shadow: 0 6px 18px rgba(0,0,0,0.35);
      transition: transform 0.2s ease, box-shadow 0.3s ease;
    }
    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 12px 28px rgba(0,0,0,0.45);
    }

    .back-link {
      display: block;
      margin-top: 15px;
      text-align: center;
      color: #9fb8ff;
      font-size: 0.95rem;
      text-decoration: none;
    }
    .back-link:hover {
      text-decoration: underline;
    }

    /* AJUSTE LOGOMARCA ZAP */
    .zap-float {
      position: fixed;
      bottom: 20px;
      right: 20px;
      width: 90px;
      height: 90px;
      z-index: 10;
    }
    .zap-float img {
      width: 100%;
      height: auto;
    }

    .alert {
      font-size: 0.9rem;
      padding: 10px;
      margin-bottom: 15px;
    }
  </style>
</head>
<body>
  <div id="particles-js"></div>

  <div class="login-card" id="tilt-card">
    <img src="./img/logo.png" alt="9x 4K by P2PLAY" class="logo">

    <?php if (!empty($login_error)): ?>
      <div class="alert alert-danger text-center" id="error-alert">
        <?= $login_error ?>
      </div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <input type="text" class="form-control form-control-lg" placeholder="Username" name="username" required autofocus>
      </div>
      <div class="form-group">
        <input type="password" class="form-control form-control-lg" placeholder="Password" name="password" required>
      </div>
      <input type="submit" class="btn btn-login btn-block" value="Log In" name="login">
    </form>

    <a href="index.php" class="back-link">← Voltar</a>
  </div>

  <!-- AJUSTE LOGOMARCA ZAP -->
  <a href="https://wa.me/5595984209043" target="_blank" class="zap-float">
    <img src="https://i.postimg.cc/Gmhx1TX1/whatsapp.png" alt="WhatsApp">
  </a>

  <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script>
    // Partículas
    particlesJS('particles-js', {
      "particles": {
        "number": { "value": 40, "density": { "enable": true, "value_area": 1000 } },
        "color": { "value": ["#FFD166", "#00AEEF"] },
        "shape": { "type": "circle" },
        "opacity": { "value": 0.4, "random": true },
        "size": { "value": 3, "random": true },
        "line_linked": { "enable": true, "distance": 120, "color": "#ffffff", "opacity": 0.15, "width": 1 },
        "move": { "enable": true, "speed": 2, "out_mode": "out" }
      },
      "interactivity": {
        "events": {
          "onhover": { "enable": true, "mode": "repulse" },
          "onclick": { "enable": true, "mode": "push" }
        },
        "modes": {
          "repulse": { "distance": 120, "duration": 0.4 },
          "push": { "particles_nb": 6 }
        }
      },
      "retina_detect": true
    });

    // Tilt efeito no bloco
    const card = document.getElementById('tilt-card');
    const maxTilt = 8;
    card.addEventListener('mousemove', (e)=>{
      const b = card.getBoundingClientRect();
      const px = (e.clientX - b.left) / b.width;
      const py = (e.clientY - b.top) / b.height;
      const tiltY = (px - 0.5) * (maxTilt * 2);
      const tiltX = (0.5 - py) * (maxTilt * 2);
      card.style.setProperty('--tiltX', tiltX.toFixed(2) + 'deg');
      card.style.setProperty('--tiltY', tiltY.toFixed(2) + 'deg');
    });
    card.addEventListener('mouseleave', ()=>{
      card.style.removeProperty('--tiltX');
      card.style.removeProperty('--tiltY');
    });

    // Esconde alerta após 5 segundos
    const alertBox = document.getElementById('error-alert');
    if(alertBox){
      setTimeout(()=>{ alertBox.style.display='none'; }, 5000);
    }
  </script>
</body>
</html>

