<?php
header('Content-Type: application/json');

$db_file = __DIR__ . "/.db.db";

$device_id = $_POST['device_id'] ?? null;
if (!$device_id) {
    die(json_encode(["error" => "Device ID não fornecido."]));
}

try {
    $db = new PDO("sqlite:$db_file");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $db->prepare("
        SELECT c.chatbot_link, c.status, c.dns_id, d.url as dns_url 
        FROM chatbot_slc_max c 
        LEFT JOIN dns d ON c.dns_id = d.id 
        ORDER BY c.id DESC LIMIT 1
    ");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$config) {
        die(json_encode(["error" => "Configurações do chatbot não encontradas."]));
    }
    
    if ($config['status'] !== 'Ativo') {
        die(json_encode(["error" => "Chatbot está desativado no momento."]));
    }
    
    $bot_url = $config['chatbot_link'];
    $dns_url = $config['dns_url'];
    
    if (empty($dns_url)) {
        die(json_encode(["error" => "DNS não configurada para o chatbot."]));
    }
    
} catch (Exception $e) {
    die(json_encode(["error" => "Erro ao acessar banco de dados: " . $e->getMessage()]));
}

// Monta o JSON para enviar ao chatbot
$json = json_encode([
    "receiveMessageAppId" => "com.whatsapp",
    "receiveMessagePattern" => ["*"],
    "senderName" => "API DE TESTE",
    "groupName" => "",
    "senderMessage" => "api_cadastro",
    "messageDateTime" => time(),
    "isMessageFromGroup" => false
]);

// Envia requisição para o chatbot
$ch = curl_init($bot_url);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($json)
]);

$response = curl_exec($ch);
if ($response === false) {
    die(json_encode(["error" => "Erro na requisição: " . curl_error($ch)]));
}
curl_close($ch);

$data = json_decode($response, true);
if (is_null($data)) {
    die(json_encode(["error" => "Resposta inválida do chatbot."]));
}

$username = $data['username'] ?? null;
$password = $data['password'] ?? null;
$payUrl   = $data['payUrl'] ?? null; // aqui pegamos o payUrl

if (empty($username) || empty($password)) {
    die(json_encode(["error" => "Usuário ou senha não retornados pelo chatbot."]));
}

$iptv_url = $dns_url . "/get.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&type=m3u_plus&output=ts";

try {
    $db = new PDO("sqlite:$db_file");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Cria tabela playlist se não existir, incluindo a coluna link
    $db->exec("
        CREATE TABLE IF NOT EXISTS playlist (
            id INTEGER PRIMARY KEY,
            dns_id INTEGER NOT NULL,
            mac_address TEXT NOT NULL,
            username TEXT,
            password TEXT,
            pin TEXT,
            device_key TEXT,
            link TEXT,
            last_used INTEGER DEFAULT (strftime('%s','now'))
        )
    ");

    $stmtCheck = $db->prepare("SELECT * FROM playlist WHERE mac_address = :mac_address");
    $stmtCheck->execute([':mac_address' => $device_id]);
    if ($stmtCheck->fetch()) {
        die(json_encode([
            "success" => false,
            "message" => "⚠️ Desculpe, você já fez o teste! Entre em contato com suporte."
        ]));
    }

    $stmt = $db->prepare("
        INSERT INTO playlist (dns_id, mac_address, username, password, pin, device_key, link, last_used)
        VALUES (:dns_id, :mac_address, :username, :password, :pin, :device_key, :link, :last_used)
    ");

    $stmt->execute([
        ':dns_id' => $config['dns_id'] ?? 1,
        ':mac_address' => $device_id,
        ':username' => $username,
        ':password' => $password,
        ':pin' => '0000',
        ':device_key' => null,
        ':link' => $payUrl,      // salvando payUrl na coluna link
        ':last_used' => time()
    ]);

    echo json_encode([
        "success" => true,
        "message" => "✅ Seu teste foi gerado com sucesso!",
        "username" => $username,
        "password" => $password,
        "iptv_url" => $iptv_url,
        "payUrl" => $payUrl
    ]);

} catch (Exception $e) {
    echo json_encode(["error" => "Erro no banco de dados: " . $e->getMessage()]);
}
